
# *****************
# Exception Vectors
# *****************

# Note: LDR PC instructions are used here because branch (B) instructions
# could not simply be copied (the branch offsets would be wrong).  Also,
# a branch instruction might not reach if the ROM is at an address >32MB).

        .text
	.code 32
	.align 	0
#	.extern Abort_ISR
#	.extern SWI_ISR
	.global	_start
	.global	start

_start:
start:
        LDR     PC, Reset_Addr
        LDR     PC, Undefined_Addr
        LDR     PC, SWI_Addr
        LDR     PC, Abort_Addr
        LDR     PC, Abort_Addr
        NOP                             /* Reserved vector */
        LDR     PC, [PC, #-0xFF0]	
        LDR     PC, FIQ_Addr
        
#       .global Reset_Handler           /* In init.s */
        .global Undefined_Handler
        .global SWI_Handler
        .global Prefetch_Handler
        .global Abort_Handler
        .global IRQ_Handler
        .global FIQ_Handler
        
Reset_Addr:     .word   Reset_Handler
Undefined_Addr: .word   Undefined_Handler
SWI_Addr:       .word   SWI_Handler
Prefetch_Addr:  .word   Prefetch_Handler
Abort_Addr:     .word   Abort_Handler
                .word   0               /* Reserved vector */
IRQ_Addr:       .word   IRQ_Handler
FIQ_Addr:       .word   FIQ_Handler


# ************************
# Exception Handlers
# ************************

# The following dummy handlers do not do anything useful in this example.
# They are set up here for completeness.

Undefined_Handler:
        B       Undefined_Handler
SWI_Handler:
        B       SWI_Handler     
Prefetch_Handler:
        B       Prefetch_Handler
Abort_Handler:
        B       Abort_Handler
IRQ_Handler:
        B       IRQ_Handler
FIQ_Handler:
        B       FIQ_Handler
        
        .end

